/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.model.cube;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.data.IModelData;
import xfacthd.framedblocks.api.model.BakedModelProxy;
import xfacthd.framedblocks.api.model.FramedBlockModel;
import xfacthd.framedblocks.api.model.quad.Modifiers;
import xfacthd.framedblocks.api.model.quad.QuadModifier;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.blockentity.FramedCollapsibleBlockEntity;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.property.NullableDirection;

public class FramedCollapsibleBlockModel
extends BakedModelProxy {
    private final BlockState state;
    private final Int2ObjectMap<CollapsibleModel> MODEL_CACHE = new Int2ObjectOpenHashMap();

    public FramedCollapsibleBlockModel(BlockState state, BakedModel baseModel) {
        super(baseModel);
        this.state = state;
    }

    @Nonnull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull Random rand, @Nonnull IModelData extraData) {
        return this.getModel(extraData).getQuads(state, side, rand, extraData);
    }

    public TextureAtlasSprite getParticleIcon(@Nonnull IModelData data) {
        return this.getModel(data).getParticleIcon(data);
    }

    private CollapsibleModel getModel(IModelData extraData) {
        Integer offsets = (Integer)extraData.getData(FramedCollapsibleBlockEntity.OFFSETS);
        int packed = offsets == null ? 0 : offsets;
        return (CollapsibleModel)this.MODEL_CACHE.computeIfAbsent(packed, key -> new CollapsibleModel(this.state, this.baseModel, key));
    }

    @Nonnull
    public IModelData getModelData(@Nonnull BlockAndTintGetter world, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nonnull IModelData tileData) {
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity instanceof FramedCollapsibleBlockEntity) {
            FramedCollapsibleBlockEntity be = (FramedCollapsibleBlockEntity)blockEntity;
            return be.getModelData();
        }
        return tileData;
    }

    private static class CollapsibleModel
    extends FramedBlockModel {
        private static final float MIN_DEPTH = 0.001f;
        private final Direction collapsedFace;
        private final boolean rotSplitEdge;
        private final float[] vertexPos = new float[4];

        public CollapsibleModel(BlockState state, BakedModel baseModel, int packedOffsets) {
            super(state, baseModel);
            this.collapsedFace = ((NullableDirection)((Object)state.m_61143_(PropertyHolder.NULLABLE_FACE))).toDirection();
            this.rotSplitEdge = (Boolean)state.m_61143_((Property)PropertyHolder.ROTATE_SPLIT_LINE);
            byte[] vertexOffsets = FramedCollapsibleBlockEntity.unpackOffsets(packedOffsets);
            for (int i = 0; i < 4; ++i) {
                this.vertexPos[i] = Math.max(1.0f - (float)vertexOffsets[i] / 16.0f, 0.001f);
            }
        }

        @Override
        protected void transformQuad(Map<Direction, List<BakedQuad>> quadMap, BakedQuad quad) {
            Direction quadDir = quad.m_111306_();
            if (this.collapsedFace == null || quadDir == this.collapsedFace.m_122424_()) {
                quadMap.get(quadDir).add(quad);
                return;
            }
            if (quadDir == this.collapsedFace) {
                float diff02 = Math.abs(this.vertexPos[0] - this.vertexPos[2]);
                float diff13 = Math.abs(this.vertexPos[1] - this.vertexPos[3]);
                boolean rotate = diff13 > diff02 != this.rotSplitEdge;
                QuadModifier.geometry(quad).apply(Modifiers.setPosition(this.vertexPos, true)).applyIf(Modifiers.rotateVertices(), rotate).export(quadMap.get(null));
            } else if (Utils.isY(this.collapsedFace)) {
                boolean top = this.collapsedFace == Direction.UP;
                int idxOne = this.getYCollapsedIndexOffset(quadDir);
                int idxTwo = Math.floorMod(idxOne + (top ? 1 : -1), 4);
                float posOne = this.vertexPos[idxOne];
                float posTwo = this.vertexPos[idxTwo];
                QuadModifier.geometry(quad).apply(Modifiers.cutSideUpDown(!top, posOne, posTwo)).export(quadMap.get(quadDir));
            } else if (Utils.isY(quadDir)) {
                boolean top = quad.m_111306_() == Direction.UP;
                float posOne = this.vertexPos[top ? 0 : 1];
                float posTwo = this.vertexPos[top ? 3 : 2];
                QuadModifier.geometry(quad).apply(Modifiers.cutTopBottom(this.collapsedFace, posOne, posTwo)).export(quadMap.get(quadDir));
            } else {
                boolean right = this.collapsedFace == quadDir.m_122427_();
                float posTop = this.vertexPos[right ? 3 : 0];
                float posBot = this.vertexPos[right ? 2 : 1];
                QuadModifier.geometry(quad).apply(Modifiers.cutSideLeftRight(this.collapsedFace, posTop, posBot)).export(quadMap.get(quadDir));
            }
        }

        @Override
        protected BakedModel getCamoModel(BlockState camoState) {
            if (camoState == ((Block)FBContent.blockFramedCube.get()).m_49966_()) {
                return this.baseModel;
            }
            return super.getCamoModel(camoState);
        }

        private int getYCollapsedIndexOffset(Direction quadFace) {
            boolean top = this.collapsedFace == Direction.UP;
            return switch (quadFace) {
                default -> throw new IncompatibleClassChangeError();
                case Direction.NORTH -> {
                    if (top) {
                        yield 3;
                    }
                    yield 2;
                }
                case Direction.EAST -> {
                    if (top) {
                        yield 2;
                    }
                    yield 3;
                }
                case Direction.SOUTH -> {
                    if (top) {
                        yield 1;
                    }
                    yield 0;
                }
                case Direction.WEST -> {
                    if (top) {
                        yield 0;
                    }
                    yield 1;
                }
                case Direction.DOWN, Direction.UP -> throw new IllegalArgumentException("Invalid facing for y face collapse!");
            };
        }
    }
}

